<!-- load main layout with datatable -->
<?= $this->extend('auth/layouts/default') ?>

<!-- load main content -->
<?= $this->section('main') ?>
<div class="content-wrapper">
	<div class="content">                
		<!-- Status Style 3 with Background -->
		<div class="card card-default bg-transparent border-0 mt-6 mb-0">
			
			<div class="card-body px-0 pb-0">
    <div class="row">
      <div class="col-sm-4">
        <div class="card mt-3">
          <div class="card-body">
            <h5 class="card-title">Total Transactions</h5>
            <h3 class="card-text"><?= $usercount ?></h3>
          </div>
        </div>
      </div>
      <div class="col-sm-4">
        <div class="card mt-3">
          <div class="card-body">
            <h5 class="card-title">New Transaction</h5>
            <h3 class="card-text"><?= $newusers ?> <span class="text-small text-muted">(in last 30 days)</span></h3>
          </div>
        </div>
      </div>
      <div class="col-sm-4">
        <div class="card mt-3">
          <div class="card-body">
            <h5 class="card-title">Paid Tsransactions</h5>
            <h3 class="card-text"><?= $percentofactiveusers ?>%</h3>
          </div>
        </div>
      </div>
    </div>

    <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-3">
        <h1 class="h2">Transactions</h1>
        <?php /* <div class="btn-toolbar mb-2 mb-md-0">
            <button type="button" class="btn btn-sm btn-primary" data-toggle="modal" data-target="#createuserformmodal"><i class="fas fa-user-plus"></i> Create New</button>
        </div> */ ?>
    </div>

    <div class="card card-default">
        <div class="table-responsive">
            <table width="100%" class="table table-hover" id="dataTables-table" data-order='[[ 0, "asc" ]]'>
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Plan</th>
                        <th>Name</th>
                        <th>Payment Email</th>
                        <th>Payment ID</th>
                        <th>Payment Status</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($data as $item):?>
                    <tr>
                        <td><?= $item['customer_id'] ?></td>
                        <td><?= $item['plan_name'] ?></td>
                        <td><?= $item['name'] ?></td>
                        <td><?= $item['email_id'] ?></td>
                        <td><?= $item['payment_id'] ?></td>
                        <td>
                            <?php if ($item['active'] == 1) : ?>
                              <a class="badge badge-pill badge-success" href="<?= site_url('admin/transaction/enable/').$item['tid'] ?>" onclick="return confirm('Are you sure you want to change the payment status for this customer?');"><i class="fas fa-user-check"></i> Paid</a>
                            <?php else : ?>
                              <a class="badge badge-pill badge-danger" href="<?= site_url('admin/transaction/disable/').$item['tid'] ?>" onclick="return confirm('Are you sure you want to change the payment status for this customer?');"><i class="fas fa-user-check"></i> Unpaid</a>                                
                            <?php endif ?>
                        </td>
                        <td class="text-right">
                            <a class="badge badge-pill badge-info" href="<?= site_url('admin/transaction/view/').$item['tid'] ?>"><i class="fas fa-edit"></i> View</a>
                            <a class="badge badge-pill badge-danger" href="<?= site_url('admin/transaction/delete/').$item['tid'] ?>" onclick="return confirm('Are you sure you want to delete this data?');"><i class="fas fa-trash"></i> Delete</a>
                        </td>
                    </tr>
                    <?php endforeach;?>
                </tbody>
            </table>
        </div>
    </div>
    </div>
		</div>
	</div>	
</div>
<?= $this->endSection() ?>