<!-- load main layout -->
<?= $this->extend('auth/layouts/default') ?>

<!-- load main content -->
<?= $this->section('main') ?>

<div class="content-wrapper">
	<div class="content">                
		<!-- Status Style 3 with Background -->
		<div class="card card-default bg-transparent border-0 mt-6 mb-0">
			
			<div class="card-body px-0 pb-0">
				<div class="row">
					<div class="col-xl-12">
						<!-- Basic Examples -->
						<div class="card card-default">
							<div class="card-header">
								<h2>View Customer Data</h2>
                                <a href="<?= site_url('admin/customer') ?>" class="btn btn-sm btn-secondary"><i class="fas fa-arrow-left"></i> Return</a>
								<!-- <a class="btn mdi mdi-code-tags" data-toggle="collapse" href="#collapse-basic-input" role="button"
								aria-expanded="false" aria-controls="collapse-basic-input"> </a> -->
							</div>
							<div class="card-body"> 
                                <div class="row"> 
                                    <div class="col-md-6">                  
                                        <ul class="list-group">
                                            <li class="list-group-item"><strong>Customer ID:</strong> <?= $record['cusid'] ?></li>
                                            <li class="list-group-item"><strong>Gender:</strong> <?= $record['gender'] ?></li>
                                            <li class="list-group-item"><strong>Name:</strong> <?= $record['name'] ?></li>
                                            <li class="list-group-item"><strong>Email:</strong> <?= $record['email'] ?></li> 
                                            <li class="list-group-item"><strong>Phone:</strong> <?= $record['phone'] ?></li>
                                            <li class="list-group-item"><strong>Address:</strong> <?= $record['address'] ?></li> 
                                            <li class="list-group-item"><strong>About You:</strong> <?= $record['about_you'] ?></li> 
                                            <li class="list-group-item">
                                                <?php if ($record['active'] == 1) : ?>
                                                <a class="badge badge-pill badge-success" href="<?= site_url('admin/customer/enable/').$record['customer_id'] ?>"><i class="fas fa-user-check"></i> Active</a>
                                                <?php else : ?>
                                                <a class="badge badge-pill badge-danger" href="<?= site_url('admin/customer/disable/').$record['customer_id'] ?>"><i class="fas fa-user-check"></i> Disabled</a>                                
                                                <?php endif ?>
                                            </li>                                  
                                        </ul>
                                    </div>
                                    <div class="col-md-6">   
                                        <ul class="list-group text-center">
                                            <li class="list-group-item"><strong>Uploaded Files</strong></li>
                                        </ul>           
                                        <?php 
                                        if( !empty($documentRecords) ){
                                            ?>
                                            <table class="table table-borderless">                                               
                                                <tbody class="mt-2">
                                                    <?php foreach($documentRecords as $row){ ?>
                                                    <tr class="garet-book txt-blue f-s-15">
                                                        <td valign="middle"><a href="<?php echo base_url($row->filepath); ?>" target="_blank"><img src="<?php echo base_url($row->filepath); ?>" width="200" alt="<?php echo $row->filename; ?>"></a></td>
                                                        <td>
                                                            <?php if ($row->status == 1) : ?>
                                                            <a class="badge badge-pill badge-success" href="<?= site_url('admin/customer/imgenable/').$row->doc_id ?>" onclick="return confirm('Are you sure you want to disable this account?');">Active</a>
                                                            <?php else : ?>
                                                            <a class="badge badge-pill badge-danger" href="<?= site_url('admin/customer/imgdisable/').$row->doc_id ?>" onclick="return confirm('Are you sure you want to active this account?');">Disabled</a>                                
                                                            <?php endif ?>                                                       
                                                            <a class="badge badge-pill badge-danger" onclick="return confirm('Are you sure want to delete <?php echo $row->filename; ?>?')" href="<?php echo base_url('admin/customer/imgdelete/'.$row->doc_id); ?>">Delete</a>
                                                        </td>							
                                                    </tr>
                                                    <?php 
                                                    }
                                                    ?>
                                                </tbody>
                                            </table>
                                            <?php 
                                        } ?>
                                    </div>
                                </div>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>	
</div>

<?= $this->endSection() ?>