<?php

namespace App\Controllers;
use Config\Email;
use Config\Services;
use App\Models\CustomerModel;
use App\Models\TransactionModel;
use App\Models\MembershipModel;

class Home extends BaseController
{
	/**
	 * Access to current session.
	 *
	 * @var \CodeIgniter\Session\Session
	 */
	protected $session;

	/**
	 * Authentication settings.
	 */
	protected $config;
	
	public function __construct()
    {
        $this->request = \Config\Services::request();
        // start session
		$this->session = Services::session();
		helper('auth');
		// helper('user_agent');
		
		header('Last-Modified: ' . gmdate("D, d M Y H:i:s") . ' GMT');
		header('Cache-Control: no-store, no-cache, must-revalidate');
		header('Cache-Control: post-check=0, pre-check=0');
		header('Pragma: no-cache');
		
    }
	
    public function index($type='')
    {		
		// echo $type; die;
		$page_data['pageTitle'] = 'Home';
		$postFdata = array_filter($this->request->getPost());
		// print_r($postFdata);
		$this->template("themes/default/home",$page_data);
    }	 
	
	public function dashbord($type='')
    {		
		// echo $type; die;
		$page_data['pageTitle'] = 'Home';
		$postFdata = array_filter($this->request->getPost());
		// print_r($postFdata);
		$this->template("themes/default/dashbord",$page_data);
    }
    
    public function mandc($type='')
    {		
		// echo $type; die;
		$page_data['pageTitle'] = 'Movies and Channels';
		// $postFdata = array_filter($this->request->getPost());
		$this->template("themes/default/pages/movies-and-channels",$page_data);
    }
	
	public function about($type='')
    {		
		// echo $type; die;
		$page_data['pageTitle'] = 'About Us';
		// $postFdata = array_filter($this->request->getPost());
		$this->template("themes/default/pages/about",$page_data);
    }

	public function training($type='')
    {		
		// echo $type; die;
		$page_data['pageTitle'] = 'Class And Training';
		// $postFdata = array_filter($this->request->getPost());
		$this->template("themes/default/pages/class-and-training",$page_data);
    }
	
	public function contact($type='')
    {		
		// echo $type; die;
		$page_data['pageTitle'] = 'Contact Us';
		// $postFdata = array_filter($this->request->getPost());
		$this->template("themes/default/pages/contact",$page_data);
    }	
	
	public function login($type='')
    {		
		// echo $type; die;
		$page_data['pageTitle'] = 'Login';
		$postFdata = array_filter($this->request->getPost());
		// print_r($postFdata); die;
		if( !empty($postFdata) ){ 
				
			// print_r($postFdata); die;
			
			// check credentials
			$customers = new CustomerModel();
			
			$customer = $customers->where('email', $this->request->getPost('email'))->first();
			
			if( empty($customer) ){
			    return redirect()->to('join-us')->withInput()->with('error', "Your email id doesn't exist.");
			}
			
			// check activation
			if (!empty($customer['active']) && $customer['active'] != 1 ) {
				return redirect()->to('login')->withInput()->with('error', lang('Auth.notActivated'));
			}else{
				$otpNo = random_int(100000, 999999);
				
				$customer_id = $customer["customer_id"];	
				
				$customers->update($customer_id, ['otp' => $otpNo]);

				$rowdata = $customers->where('customer_id', $customer_id)->first();
				send_otp_customer_email($rowdata['email'], $rowdata);
				
				return redirect()->to(base_url('verify-otp'))->with('success', 'OTP has beed send to your register email id(inbox or spam), Please check your email and confirm the OTP');	
			}
						
		}
		$this->template("themes/default/pages/login",$page_data);
    }

	public function otp($type='')
    {		
		// echo $type; die;
		$page_data['pageTitle'] = 'Verify OTP';
		$postFdata = $this->request->getPost();
		// print_r($postFdata); die;
		if( !empty($postFdata) ){ 
			// print_r($postFdata); die;
			// check credentials
			$customers = new CustomerModel();
			
			$customer = $customers->where('otp', $postFdata['otp'])->first();
			// echo $customers->getLastQuery(); 
			if (empty($customer)) {
				return redirect()->to('verify-otp')->withInput()->with('error', 'Invalid OTP, Please enter valid OTP.');
			}else{

				// verify OTP
				if ($customer['otp'] != $postFdata['otp']) {
					return redirect()->to('verify-otp')->withInput()->with('error', 'Invalid OTP, Please enter valid OTP.');
				}		

				// login OK, save customer data to session
				$this->session->set('isLoggedIn', true);
				$this->session->set('customer_id', $customer["customer_id"]);
				$this->session->set('customerData', [
					'id' 			=> $customer["customer_id"],
					'name' 		=> $customer["name"],
					'phone' 		=> $customer["phone"],
					'address' 	=> $customer["address"],
					'active' 		=> $customer["active"],
					'email' 		=> $customer["email"],
					'new_email' 	=> $customer["new_email"]
				]);				
			
				return redirect()->to(base_url('account'))->with('success', 'Thanks, Your OTP was validated.');
			}			
		}
		$this->template("themes/default/pages/otp",$page_data);
    }
	
	
	public function signup()
	{
		$postFdata = array_filter($this->request->getPost());
		$page_data['postFdata'] = array_filter($this->request->getPost());
		
		// print_r($sessionpost); die;
		if( !empty($postFdata) ){ 
			// print_r($sessionpost); die;
			helper('text');
			// $password = randomPassword(); // "demo123"; //rand();
			// save new customer, validation happens in the model
			$customer = new CustomerModel();
			// $getRule = $customer->getRule('registration');
			// $customer->setValidationRules($getRule);
			
			$rowdata = $customer->where('email', $this->request->getPost('email'))->first();
			
			if( empty($rowdata) ){
				$data = [
				'name'          	=> $this->request->getPost('name'),
				'email'         	=> $this->request->getPost('email'),
				'phone'     		=> $this->request->getPost('phone'),
				'gender'     		=> $this->request->getPost('gender'),
				'category_id'     		=> $this->request->getPost('category_id'),
				'about_you'     	=> $this->request->getPost('about_you'),
				'address'     	=> $this->request->getPost('address'),				
				];
				
				if (! $customer->save($data)) {
					return redirect()->back()->withInput()->with('errors', $customer->errors());
				}
				
				$customer_id = $customer->insertID();
				$this->session->set('customerPostData', [
					'customer_id' 		=> $customer_id,
					'phone' 		=> $data["phone"],
					'name' 	=> $data["name"],
					'email' 		=> $data["email"],
				]);
				
				// helper('auth'); 
				// send_activation_email($data['email'], $data['activate_hash']);
				// send_email_customer($data['email'], $data);
				// success
				// return redirect()->to(site_url('connexion'))->with('success', lang('Auth.registrationSuccess'));
				return redirect()->to('package')->with('success', lang('Auth.step1'));
				// echo 'sdsd'; die;
			}else{	
				
				if( !empty($rowdata['active']) && $rowdata['active'] == 2){
					return redirect('/')->with('error', lang('Auth.status2'));
				}

				if( !empty($rowdata['active']) && $rowdata['active'] == 1){
					return redirect('login')->with('error', lang('Auth.accountAlreadyExists'));
				}else{

					$data = [
					'name'          	=> $this->request->getPost('name'),
					'email'         	=> $this->request->getPost('email'),
					'phone'     		=> $this->request->getPost('phone'),
					'gender'     		=> $this->request->getPost('gender'),
					'category_id'     		=> $this->request->getPost('category_id'),
					'about_you'     	=> $this->request->getPost('about_you'),
					'address'     	=> $this->request->getPost('address'),				
					];
					
					$customer_id = $rowdata['customer_id'];
							  // $customer->where('customer_id', $customer_id);
					$result = $customer->update($customer_id, $data);
					// echo $customer->getLastQuery(); die;
					if (! $result) {
						return redirect()->back()->withInput()->with('errors', $customer->errors());
					}

					
					$this->session->set('customerPostData', [
						'customer_id' 		=> $customer_id,
						'phone' 		=> $data["phone"],
						'name' 	=> $data["name"],
						'email' 		=> $data["email"],
					]);
					
					// helper('auth'); 
					// send_activation_email($data['email'], $data['activate_hash']);
					// send_email_customer($data['email'], $data);
					// success
					// return redirect()->to(site_url('connexion'))->with('success', lang('Auth.registrationSuccess'));
					return redirect()->to('package')->with('success', lang('Auth.step1'));

				}
				
			}				
		}	
	}
	
	public function terms($type='')
    {		
		// echo $type; die;
		$page_data['pageTitle'] = 'Terms and Conditions';
		// $postFdata = array_filter($this->request->getPost());
		$this->template("themes/default/pages/terms",$page_data);
    }
	
	public function eventDetail($type='')
    {		
		// echo $type; die;
		$page_data['pageTitle'] = 'Terms and Conditions';
		// $postFdata = array_filter($this->request->getPost());
		$this->template("themes/default/pages/event-detail",$page_data);
    }

	public function events($type='')
    {		
		// echo $type; die;
		$page_data['pageTitle'] = 'Events';
		// $postFdata = array_filter($this->request->getPost());
		$this->template("themes/default/pages/events",$page_data);
    }

	public function joinus($type='')
    {		
		// echo $type; die;
		$page_data['pageTitle'] = 'Join Us';
		// $postFdata = array_filter($this->request->getPost());
		$this->template("themes/default/pages/joinus",$page_data);
    }

	public function achievers($type='')
    {		
		// echo $type; die;
		$page_data['pageTitle'] = 'Achievers';
		// $postFdata = array_filter($this->request->getPost());
		$this->template("themes/default/pages/achievers",$page_data);
    }
	
	public function package()
    {		
		// echo $type; die;
		$page_data['pageTitle'] = 'Packages';
		
		/* if( !empty($this->session->customerPostData) ){
			// update session data
			$this->session->push('customerPostData', [
				'subscription_id' 		=> $id,
			]);
		}	 */	
		
		$postFdata = array_filter($this->request->getPost());
		if( !empty($postFdata) ){
			$this->session->push('customerPostData', [
				'subscription_id' 		=> $postFdata['subscription_id'],
			]);
			return redirect()->to('checkout')->with('success', lang('Auth.step2'));
		}

		$this->template("themes/default/pages/package",$page_data);
    }
	
	public function checkout($id='')
    {		
		// echo $type; die;
		$page_data['pageTitle'] = 'Checkout';
		$postFdata = array_filter($this->request->getPost());
		$page_data['postFdata'] = array_filter($this->request->getPost());
		$customerPostData = session('customerPostData');
				
		if( !empty($postFdata) ){
			
			helper('text');
			$transaction = new TransactionModel();
			
			// print_r($customerPostData); die;
			/* $rowdata = $transaction->where('email', $this->request->getPost('email'))->first();
			
			if( empty($rowdata) ){ */
				$data = [
				'customer_id'          	=> $customerPostData['customer_id'],
				'subscription_id'          	=> $customerPostData['subscription_id'],
				'email_id'         	=> $this->request->getPost('email'),
				'payment_id'         	=> $this->request->getPost('payment_id'),						
				];
				
							
				if (! $transaction->save($data)) {
					return redirect()->back()->withInput()->with('errors', $transaction->errors());
				}

					$data1 = [
					'active'          	=> 2,
					'mp_id'         	=> $customerPostData['subscription_id'],									
					];
					
					$customer = new CustomerModel();
					$customer_id = $customerPostData['customer_id'];
							  // $customer->where('customer_id', $customer_id);
					$result = $customer->update($customer_id, $data1);
				
				// helper('auth'); 
				// send_activation_email($data['email'], $data['activate_hash']);
				// send_email_customer($data['email'], $data);
				// success
				return redirect()->to('login')->with('success', 'Thank you, your payment success. Our admin team will check and get back to you within 24 hours.');
				// echo 'sdsd'; die;
			/* }else{	
				return redirect('login')->with('error', 'Server error Or payment failled, Our admin will check and get back to you within 24 hours.');
			} */
		}

		// check credentials
		$membership = new MembershipModel();

		$subscription_id = !empty($customerPostData['subscription_id']) ? $customerPostData['subscription_id'] : 1; 
		$subscription = $membership->where('plan_id', $subscription_id)->first();		
		$page_data['subscription'] = $subscription;
			
		$this->template("themes/default/pages/checkout",$page_data);
    }
	
		
	//--------------------------------------------------------------------

    public function forgotPassword()
	{
		if ($this->session->isLoggedIn) {
			return redirect()->to('login');
		}
		$page_data['pageTitle'] = 'Forgot Password';		
		$this->template("front_end/auth/forgot",$page_data);
		// return view('front_end/auth/forgot');
	}

    //--------------------------------------------------------------------

	public function attemptForgotPassword()
	{
		// validate request
		if (! $this->validate(['email' => 'required|valid_email'])) {
            return redirect()->back()->with('error', lang('Auth.wrongEmail'));
        }

		// check if email exists in DB
		$customer = new CustomerModel();

		$user = $customer->where('email', $this->request->getPost('email'))->first();

		if (! $user) {
            return redirect()->back()->with('error', lang('Auth.wrongEmail'));
        }

        // check if email is already sent to prevent spam
        /* if (! empty($user['reset_expires']) && $user['reset_expires'] >= time()) {
			return redirect()->back()->with('error', lang('Auth.emailAlreadySent'));
        } */

		// set reset hash and expiration
		helper('text');
		$updatedUser['customer_id'] = $user['customer_id'];
		// $updatedUser['reset_hash'] = random_string('alnum', 32);
		$updatedUser['password'] = randomPassword(); // ;
		$updatedUser['reset_expires'] = time() + HOUR;
		$customer->save($updatedUser);

		// send password reset e-mail
		helper('auth');
        // send_password_reset_email($this->request->getPost('email'), $updatedUser['reset_hash']);
		send_email_customer_resetpwd($this->request->getPost('email'), $updatedUser['password']);
        return redirect()->back()->with('success', lang('Auth.forgottenPasswordEmail'));
	}
	
	public function formdata()
    {
		/// print_r($_POST);
		// Insert an array of values
		/* $this->formdata->insert(array(		   
		   'address'     => $_POST['address']
		));
		print_r($this->formdata->contents());  */
		foreach($_POST as $k => $v){
			$this->session->set('form_'.$k, $v);
		}
		/* $page_data['pageTitle'] = 'Home';
        // return view('home');
		// $view = new \CodeIgniter\View\View();
		// $this->template('theme/home', $page_data);
		// $view->render('theme/default/home');	
		$this->template("front_end/default/home",$page_data); */
		die;
    }
	
	public function ajaxMaterial()
    {		
		if( !empty($_POST['id']) ){
			$db      = \Config\Database::connect();
			$builder = $db->table('material');
			$builder->where('sa_id', $_POST['id']);
			$query   = $builder->get();  // Produces: SELECT * FROM mytable
			$page_data['getdata'] = $query->getResult();
			return view('front_end/ajax/material', $page_data);
			
		}
		die;
    }
	
}
