<?php
namespace App\Controllers\Auth;

use CodeIgniter\Controller;
use Config\Email;
use Config\Services;
use App\Models\CustomerModel;
use App\Models\LogsModel;

class CustomerLogin extends Controller
{
	/**
	 * Access to current session.
	 *
	 * @var \CodeIgniter\Session\Session
	 */
	protected $session;

	/**
	 * Authentication settings.
	 */
	protected $config;


    //--------------------------------------------------------------------

	public function __construct()
	{
		// start session
		$this->session = Services::session();
	}

    //--------------------------------------------------------------------

	/**
	 * Displays login form or redirects if user is already logged in.
	 */
	public function login()
	{
		
		if ($this->session->isLoggedIn) {
			return redirect()->to('account');
		}

		return view('front_end/auth/login');
	}

    //--------------------------------------------------------------------

	/**
	 * Attempts to verify user's credentials through POST request.
	 */
	public function attemptLogin()
	{
		// print_r('asd'); die;
		// validate request
		$rules = [
			'email'		=> 'required|valid_email',
			'password' 	=> 'required|min_length[5]',
		];

		if (! $this->validate($rules)) {
			return redirect()->to('login')->withInput()->with('errors', $this->validator->getErrors());
		}

		// check credentials
		$customers = new CustomerModel();
		
		$customer = $customers->where('email', $this->request->getPost('email'))->first();
		// print_r($customer); die;
		if ( is_null($customer) || ! password_verify($this->request->getPost('password'), $customer['password_hash']) ) 
		{
			return redirect()->to('login')->withInput()->with('error', lang('Auth.wrongCredentials'));
		}

		// check activation
		if (!$customer['active']) {
			return redirect()->to('login')->withInput()->with('error', lang('Auth.notActivated'));
		}
		
		// $this->session->remove(['solar_id']);
		// login OK, save customer data to session
		$this->session->set('isLoggedIn', true);
		$this->session->set('customer_id', $customer["customer_id"]);
		$this->session->set('customerData', [
            'id' 			=> $customer["customer_id"],
			'name' 		=> $customer["firstname"].' '.$customer["lastname"],
            'phone' 		=> $customer["phone"],
            'firstname' 	=> $customer["firstname"],
            'lastname' 		=> $customer["lastname"],
            'email' 		=> $customer["email"],
            'new_email' 	=> $customer["new_email"]
        ]);

        // save login info to customer login logs for tracking
        // get customer agent
        $agent = $this->request->getUserAgent();
        // load logs model
		$logs = new LogsModel();
		// logs data
		$userlog = [
			'date'	=> date("Y-m-d"),
			'time'	=> date("H:i:s"),
			'reference'	=> $customer["customer_id"],
			'name'	=> $customer["firstname"].' '.$customer["lastname"],
			'ip'	=> $this->request->getIPAddress(),
			'browser'	=> $agent->getBrowser(),
			'status'	=> 'Success' 
		];
		// logs to database
		$logs->save($userlog);

        return redirect()->to('account');
	}

    //--------------------------------------------------------------------

	/**
	 * Log the user out.
	 */
	public function logout()
	{
		$this->session->remove(['isLoggedIn', 'customerData']);

        return redirect()->to('login');
	}

}
