<?php
namespace App\Controllers\Auth;

use CodeIgniter\Controller;
use Config\Email;
use Config\Services;
use App\Models\CustomerModel;
use App\Models\DocumentsModel;
use App\Models\MembershipModel;
use App\Models\TransactionModel;

class Customer extends Controller
{

	/**
	 * Access to current session.
	 *
	 * @var \CodeIgniter\Session\Session
	 */
	protected $session;

	/**
	 * Authentication settings.
	 */
	protected $config;


    //--------------------------------------------------------------------

	public function __construct()
	{
		// start session
		$this->session = Services::session();
		$this->customers = new CustomerModel();	
		$this->documents = new DocumentsModel();
		$this->mship = new MembershipModel();
		$this->trans = new TransactionModel();
	}

    //--------------------------------------------------------------------

	/**
	 * Displays account settings.
	 */
	public function account()
	{
		if (! $this->session->isLoggedIn) {
			return redirect()->to('login');
		}
		
		$page_data['pageTitle'] = 'Dashborad';
		$page_data['userData'] = $this->session->customerData;
		$customer_id = $this->session->customer_id;
		// $customer = $this->customers->where('customer_id', $customer_id)->first();
		$db      = \Config\Database::connect();
		$trans = $db->table('customer');
							$trans->where('customer.customer_id', $customer_id);
							// $trans->where('transactions.active', '1');
							$trans->select('membership_plan.*, customer.name, customer.email, customer.phone,customer.gender,customer.address,customer.about_you');
							$trans->join('membership_plan', 'membership_plan.plan_id = customer.mp_id', 'left');
				$queryDoc   = $trans->get();  // Produces: SELECT * FROM mytable
				$record = $queryDoc->getRowArray();	
		$page_data['customer'] =  $record;		
		return view('themes/default/auth/starter', $page_data);
	}
	
	public function uploadfile($type='', $id=0)
    {
		// echo $type; die;
		if (! $this->session->isLoggedIn) {
			return redirect()->to('login');
		}
		
		$database = \Config\Database::connect();
        $document_db = $database->table('documents');
		
		$page_data['userData'] = $this->session->customerData;
		// echo $type; die;
		$page_data['pageTitle'] = 'Upload Files';
		$db = db_connect();
		
		$customer_id = $this->session->customer_id;
		$customer = $this->customers->where('customer_id', $customer_id)->first();

		// print_r($solarRow); die; 
		switch ($type) {
		 			  
		  case 'delete':
		  
			// get the user id
			// $id = $this->request->uri->getSegment(3);
			// delete user using the id
			$this->documents->delete($id);
			return redirect()->back()->with('success', 'Image deleted successfully');								
			break;
		  default:		
			$postData = $this->request->getFileMultiple('document'); // $this->request->getPost();

			$data['form_id'] = $customer_id;
			// $data['form_type'] = $this->session->name;
			$data['upload_from'] = 'customer'; // $this->session->name;
			
			if( !empty($postData) ){

				$filesUploaded = 0; 
				if($this->request->getFileMultiple('document'))
				{
					$files = $this->request->getFileMultiple('document');
		
					foreach ($files as $key => $file) {
						// print_r($file);	
						if ($file->isValid() && ! $file->hasMoved())
						{
							// $data['filename'] = isset($postData['filename'][$key]) ? $postData['filename'][$key] : $file->getClientName();
							$newName = $file->getRandomName();
							$file->move(ROOTPATH.'/public/uploads/customer/'.$customer_id.'/', $newName);
							/* $data = [
								'filename' => $file->getClientName(),
								'filepath' => '/uploads/calcule/customer/'.$response->newName(),
								'type' => $file->getClientExtension()
							]; */
							$data['filename'] = $file->getClientName();
							$data['filepath'] = '/public/uploads/customer/'.$customer_id.'/'.$newName;
							$save = $document_db->insert($data);
							// print_r($data);
							$filesUploaded++;
						}
						
					}
		
				}

				if($filesUploaded <= 0) {
					return redirect()->back()->with('error', 'Files not upload.');
				}
		
				return redirect()->back()->with('success', $filesUploaded . ' Files uploaded successfully.');
			}

			$document = $this->documents;
					   $document->where('form_id', $customer_id);
					   $document->where('upload_from', 'customer');
			$queryDoc   = $document->get();  // Produces: SELECT * FROM mytable
			$page_data['documentRecords'] = $queryDoc->getResult();
			$page_data['customer_id'] = $customer_id;

			$db      = \Config\Database::connect();
			$trans = $db->table('customer');
								$trans->where('customer.customer_id', $customer_id);
								// $trans->where('transactions.active', '1');
								$trans->select('membership_plan.*, customer.name, customer.email, customer.phone,customer.gender,customer.address,customer.about_you');
								$trans->join('membership_plan', 'membership_plan.plan_id = customer.mp_id', 'left');
					$queryDoc   = $trans->get();  // Produces: SELECT * FROM mytable
					$record = $queryDoc->getRowArray();	
			$page_data['customer'] =  $record;	

			return view("themes/default/auth/uploadfile",$page_data);
		}	
				
    }
	
	public function myaccount()
	{
		if (! $this->session->isLoggedIn) {
			return redirect()->to('login');
		}
		
		$page_data['pageTitle'] = 'My Account';
		
		$customer_id = $this->session->customer_id;
		$customer = $this->customers->where('customer_id', $customer_id)->first();		
		$page_data['record'] = $customer;
		return view('themes/default/auth/myaccount', $page_data);
	}
	
	public function mypayments()
	{
		if (! $this->session->isLoggedIn) {
			return redirect()->to('login');
		}
		
		$page_data['pageTitle'] = 'My Payments';
		$page_data['userData'] = $this->session->customerData;

		$customer_id = $this->session->customer_id;
		$db      = \Config\Database::connect();
		$trans = $db->table('transactions');
					$trans->where('transactions.customer_id', $customer_id);
					// $trans->where('transactions.active', '1');
					$trans->select('*');
					$trans->join('customer', 'customer.customer_id = transactions.customer_id', 'left');
					$trans->join('membership_plan', 'membership_plan.plan_id = transactions.subscription_id', 'left');
		$queryDoc   = $trans->get();  // Produces: SELECT * FROM mytable
		$page_data['records'] = $queryDoc->getResultArray();
		
		return view('themes/default/auth/mypayments', $page_data);
	}
	
		
	public function downloadfile($type='', $id=0)
    {
		// echo $type; die;
		if (! $this->session->isLoggedIn) {
			return redirect()->to('login');
		}
		
		$page_data['userData'] = $this->session->customerData;
		// echo $type; die;
		$page_data['pageTitle'] = 'Download Files';
		$db = db_connect();
		
		// print_r($solarRow); die; 
		switch ($type) {
		  case 'calcule':
			$document = $this->documents;
					   $document->where('form_id', $id);
					   $document->where('upload_from', 'admin');
					   $document->where('form_type', 'calcule');
			$queryDoc   = $document->get();  // Produces: SELECT * FROM mytable
			$page_data['documentRecords'] = $queryDoc->getResult();
			return view('themes/default/auth/downloadfile', $page_data);
			break;	
		  default:				
			$document = $this->documents;
					   $document->where('form_id', $id);
					   $document->where('upload_from', 'admin');
					   $document->where('form_type', 'solaire');
			$queryDoc   = $document->get();  // Produces: SELECT * FROM mytable
			$page_data['documentRecords'] = $queryDoc->getResult();
			return view('themes/default/auth/downloadfile', $page_data);
		}	
				
    }	
	
	//--------------------------------------------------------------------

	/**
	 * Displays profile page.
	 */
	public function profile()
	{
		if (! $this->session->isLoggedIn) {
			return redirect()->to('login');
		}
		
		$page_data['pageTitle'] = 'Profile';
		$page_data['userData'] = $this->session->customerData;
		$customer_id = $this->session->customer_id;
		$customer = $this->customers->where('customer_id', $customer_id)->first();		
		$page_data['record'] = $customer;
		
		return view('themes/default/auth/profile', $page_data);
	}
	
	//--------------------------------------------------------------------

	/**
	 * Updates regular account settings.
	 */
	public function updateProfile()
	{
		if (! $this->session->isLoggedIn) {
			return redirect()->to('login');
		}
		
		// update user, validation happens in model		
		// $getRule = $this->customers->getRule('updateProfile');
		// $this->customers->setValidationRules($getRule);

		/* $user = [
			'customer_id'  	=> $this->session->get('customerData.id'),
			'firstname' 	=> $this->request->getPost('firstname'),
			'lastname' 	=> $this->request->getPost('lastname'),
			'email' 	=> $this->request->getPost('email')
		]; */
		
		$customer_id = $this->session->customer_id;
		
		$postFdata = array_filter($this->request->getPost());
		// print_r($postFdata); die;
		$update = $this->customers->update($customer_id, $postFdata);
		// print_r($update); die;
		if ( empty($update) ) {
			return redirect()->back()->withInput()->with('errors', $this->customers->errors());
        }

        // update session data
        // $this->session->push('userData', $user);

        return redirect()->to('profile')->with('success', lang('Auth.updateSuccess'));
	}

    //--------------------------------------------------------------------

	/**
	 * Updates regular account settings.
	 */
	public function updateAccount()
	{
		if (! $this->session->isLoggedIn) {
			return redirect()->to('login');
		}
		
		// update user, validation happens in model
		$users = new UserModel();
		$getRule = $this->customers->getRule('updateAccount');
		$this->customers->setValidationRules($getRule);

		$user = [
			'id'  	=> $this->session->get('customerData.id'),
			'name' 	=> $this->request->getPost('name')
		];

		if (! $this->customers->save($user)) {
			return redirect()->back()->withInput()->with('errors', $this->customers->errors());
        }

        // update session data
        $this->session->push('customerData', $user);

        return redirect()->to('account')->with('success', lang('Auth.updateSuccess'));
	}

    //--------------------------------------------------------------------

	/**
	 * Handles password change.
	 */
	public function changePassword()
	{
		if (! $this->session->isLoggedIn) {
			return redirect()->to('login');
		}
		
		// check current password		
		$page_data['pageTitle'] = 'Change Password';
		$customer_id = $this->session->customer_id;
		$customer = $this->customers->where('customer_id', $customer_id)->first();		
		$page_data['record'] = $customer;
		
		return view('themes/default/auth/change-password', $page_data);
	}
	
	/**
	 * Handles password change.
	 */
	public function updatePassword()
	{
		
		// validate request
		$rules = [
			'password' 	=> 'required|min_length[5]',
			'new_password' => 'required|min_length[5]',
			'new_password_confirm' => 'required|matches[new_password]'
		];

		if (! $this->validate($rules)) {
			return redirect()->to('change-password')->withInput()
				->with('errors', $this->validator->getErrors());
		}
		
		// check current password
		$customer = $this->customers->find($this->session->get('customerData.id'));
		if (
			! $customer ||
			! password_verify($this->request->getPost('password'), $customer['password_hash'])
		) {
			return redirect()->to('change-password')->withInput()->with('error', lang('Auth.wrongCredentials'));
		}

		// update user's password
		$updatedUser['customer_id'] = $this->session->get('customerData.id');

		$updatedUser['password'] = $this->request->getPost('new_password');

		$this->customers->save($updatedUser);

		// redirect to account with success message
		return redirect()->to('profile')->with('success', lang('Auth.passwordUpdateSuccess'));
	}

    //--------------------------------------------------------------------

	/**
	 * Deletes user account.
	 */
	public function deleteAccount()
	{
		// check current password
		$users = new UserModel();
		
		$user = $this->customers->find($this->session->get('customerData.id'));

		if (
			! $user ||
			! password_verify($this->request->getPost('password'), $user['password_hash'])
		) {
			return redirect()->back()->withInput()->with('error', lang('Auth.wrongCredentials'));
		}

		// delete account from DB
		$this->customers->delete($this->session->get('customerData.id'));

		// log out user
		$this->session->remove(['isLoggedIn', 'userData']);

		// redirect to register with success message
		return redirect()->to('register')->with('success', lang('Auth.accountDeleted'));
	}

}
