<?php
namespace App\Controllers;

use CodeIgniter\Controller;
use Config\Email;
use Config\Services;
use App\Models\CustomerModel;
use App\Models\DocumentsModel;
use App\Models\MembershipModel;
use App\Models\TransactionModel;

class AdminController extends Controller
{

	/**
	 * Access to current session.
	 *
	 * @var \CodeIgniter\Session\Session
	 */
	protected $session;

	/**
	 * Authentication settings.
	 */
	protected $config;


    //--------------------------------------------------------------------

	public function __construct()
	{
		// start session
		$this->session = Services::session();
		$this->customers = new CustomerModel();	
		$this->documents = new DocumentsModel();
		$this->mship = new MembershipModel();
		$this->trans = new TransactionModel();
	}

    //--------------------------------------------------------------------	
	public function index($type='', $id=0) {
		// print_r($solarRow); die; 
		// check if user is signed-in if not redirect to login page
		if (! $this->session->isAdminLoggedIn) {
			return redirect()->to('login');
		}

		switch ($type) {
			case 'edit':
				
				$record = $this->customers->where('customer_id', $id)->first(); 

				// load the view with session data
				return view('admin/customer/edit', [
						'userData' => $this->session->userData, 
						'record' => $record, 
					]);
			 
			  break;
			case 'update':
				
				$record = $this->customers->where('customer_id', $id)->first(); 

				$rules = [
					'customer_id'	=> 'required|is_natural',
					'name'	=> 'required|alpha_space|min_length[2]',					
					'email'	=> 'required|valid_email|is_unique[customer.email,customer_id,{customer_id}]',
					'active'	=> 'required|integer',
				];
		
				if (! $this->validate($rules)) {
					return redirect()->back()->withInput()->with('errors', $this->validator->getErrors());
				}		
	
				$data = [
					'customer_id'  	=> $this->request->getPost('customer_id'),
					'name' 	=> $this->request->getPost('name'),					
					'email' 	=> $this->request->getPost('email'),
					'active' 	=> $this->request->getPost('active')
				];
		
				if (! $this->customers->save($data)) {
					return redirect()->back()->withInput()->with('errors', $this->customers->errors());
				}
		
				return redirect()->back()->with('success', lang('Auth.updateSuccess'));
			 
			  break;
			case 'view':
				
				$record = $this->customers->where('customer_id', $id)->first(); 
				$document = $this->documents;
					   $document->where('form_id', $id);
					   $document->where('upload_from', 'customer');
				$queryDoc   = $document->get();  // Produces: SELECT * FROM mytable
				$documentRecords = $queryDoc->getResult();
				// load the view with session data
				return view('admin/customer/view', [
						'userData' => $this->session->userData, 
						'record' => $record,
						'documentRecords' => $documentRecords, 
					]);
			 
			  break;

			case 'imgdelete':
		  
				// $id = $this->request->uri->getSegment(3);
				// delete user using the id
				$this->documents->delete($id);
				return redirect()->back()->with('success', 'Image deleted successfully');								
				break;
			case 'imgenable':
				
					$data = [
						'doc_id'  	=> $id,
						'status'  	=> 0,
					];
			
					if (! $this->documents->save($data)) {
						return redirect()->back()->withInput()->with('errors', $this->documents->errors());
					}
			
					return redirect()->back()->with('success', lang('Auth.disable'));
				 
				  break;	
			case 'imgdisable':
					
					$data = [
						'doc_id'  	=> $id,
						'status'  	=> 1,
					];
			
					if (! $this->documents->save($data)) {
						return redirect()->back()->withInput()->with('errors', $this->documents->errors());
					}
			
					return redirect()->back()->with('success', lang('Auth.enable'));
				 
				  break;

			case 'enable':
				
				$data = [
					'customer_id'  	=> $id,
					'active'  	=> 0,
				];
		
				if (! $this->customers->save($data)) {
					return redirect()->back()->withInput()->with('errors', $this->customers->errors());
				}
		
				return redirect()->back()->with('success', lang('Auth.disable'));
			 
			  break;	
			case 'disable':
				
				$data = [
					'customer_id'  	=> $id,
					'active'  	=> 1,
				];
		
				if (! $this->customers->save($data)) {
					return redirect()->back()->withInput()->with('errors', $this->customers->errors());
				}
		
				return redirect()->back()->with('success', lang('Auth.enable'));
			 
			  break;
			case 'delete':
				
				$this->customers->delete($id);

       			return redirect()->back()->with('success', lang('Auth.recordDeleted'));
			 
			  break;		  
			default:	
				// current year and month variable 
				$ym = date("Y-m");

				// getall users
				// $this->customers->where('customer.customer_id <> 1'); // ignore all users in Group 1
				$records = $this->customers->findAll(); 
				
				// count all rows in users table
				$counts = count($records); // $users->countAll(); 
				
				// count all active user in the last 30 days
				$newrecords = $this->customers->like("created_at", $ym)->countAllResults(); 

				// count all active users
				$activerecords = $this->customers->where('active', 1)->countAllResults(); 

				// calculate active users in how many percents
				// $percentofactive = ($activerecords / $counts) * 100;
				$percentofactive = !empty($counts) ? ($activerecords / $counts) * 100 : 0;
				
				// load the view with session data
				return view('admin/customer/list', [
						'userData' => $this->session->userData, 
						'data' => $records, 
						'usercount' => $counts, 
						'newusers' => $newrecords,
						'percentofactiveusers' => $percentofactive
					]);
		  }
	}

	//--------------------------------------------------------------------	
	public function transaction($type='', $id=0) {
		// print_r($solarRow); die; 
		// check if user is signed-in if not redirect to login page
		if (! $this->session->isAdminLoggedIn) {
			return redirect()->to('login');
		}

		switch ($type) {

			case 'view':
				
				
				$db      = \Config\Database::connect();
				$trans = $db->table('transactions');
							$trans->where('transactions.tid', $id);
							// $trans->where('transactions.active', '1');
							$trans->select('transactions.*, membership_plan.*, customer.name, customer.email, customer.phone,customer.gender,customer.address,customer.about_you');
							$trans->join('customer', 'customer.customer_id = transactions.customer_id', 'left');
							$trans->join('membership_plan', 'membership_plan.plan_id = transactions.subscription_id', 'left');
				$queryDoc   = $trans->get();  // Produces: SELECT * FROM mytable
				$record = $queryDoc->getRowArray();
				// load the view with session data
				return view('admin/transaction/view', [
						'userData' => $this->session->userData, 
						'record' => $record,
					]);
			 
			  break;

			case 'enable':
				
				
				$data = [
					'tid'  	=> $id,
					'active'  	=> 0,
				];
		
				if (! $this->trans->save($data)) {
					return redirect()->back()->withInput()->with('errors', $this->trans->errors());
				}
				
				$record = $this->trans->where('tid', $id)->first();
				$cusdata = [
					'customer_id'  	=> $record['customer_id'],
					'cusid'  	=> '',
					'lid'  	=> '',
				];
		
				$this->customers->save($cusdata);
		
				return redirect()->back()->with('success', lang('Auth.disable'));
			 
			  break;	
			case 'disable':
				
				$data = [
					'tid'  	=> $id,
					'active'  	=> 1,
				];
		
				if (! $this->trans->save($data)) {
					return redirect()->back()->withInput()->with('errors', $this->trans->errors());
				}

				$result = $this->customers->select('max(lid) as maxCusid')->first();

				$maxCusid = 1;
				if( !empty($result['maxCusid']) ){
					$maxCusid = $result['maxCusid'] + 1;
				}

				$d = date('y') ;
				$mnth = date("m");
				$customid = 'G2J'.$d.$mnth.$maxCusid;				
				$record = $this->trans->where('tid', $id)->first();
                // echo $id; die;
				// print_r($record); die;
				$cusdata = [
					'customer_id'  	=> $record['customer_id'],
					'cusid'  	=> $customid,
					'lid'  	=> $maxCusid,
				];
		
				$this->customers->save($cusdata);
		
				return redirect()->back()->with('success', lang('Auth.enable'));
			 
			  break;
			case 'delete':
				
				$this->trans->delete($id);

       			return redirect()->back()->with('success', lang('Auth.recordDeleted'));
			 
			  break;		  
			default:	
			
				// current year and month variable 
				$ym = date("Y-m");

				$db      = \Config\Database::connect();
				$trans = $db->table('transactions');
							// $trans->where('transactions.customer_id', $customer_id);
							// $trans->where('transactions.active', '1');
							$trans->select('transactions.*, membership_plan.*, customer.name, customer.email, customer.phone,');
							$trans->join('customer', 'customer.customer_id = transactions.customer_id', 'left');
							$trans->join('membership_plan', 'membership_plan.plan_id = transactions.subscription_id', 'left');
				$queryDoc   = $trans->get();  // Produces: SELECT * FROM mytable
				$records = $queryDoc->getResultArray();
				
				// count all rows in users table
				$counts = count($records); // $users->countAll(); 
				
				// count all active user in the last 30 days
				$newrecords = $this->trans->like("created_at", $ym)->countAllResults(); 

				// count all active users
				$activerecords = $this->trans->where('active', 1)->countAllResults(); 
				// calculate active users in how many percents
				
				$percentofactive = !empty($counts) ? ($activerecords / $counts) * 100 : 0;
				
				// load the view with session data
				return view('admin/transaction/list', [
						'userData' => $this->session->userData, 
						'data' => $records, 
						'usercount' => $counts, 
						'newusers' => $newrecords,
						'percentofactiveusers' => $percentofactive
					]);
		  }
	}

}
