<?php namespace Config;

// Create a new instance of our RouteCollection class.
$routes = Services::routes();

// Load the system's routing file first, so that the app and ENVIRONMENT
// can override as needed.
if (file_exists(SYSTEMPATH . 'Config/Routes.php'))
{
	require SYSTEMPATH . 'Config/Routes.php';
}

/**
 * --------------------------------------------------------------------
 * Router Setup
 * --------------------------------------------------------------------
 */
$routes->setDefaultNamespace('App\Controllers');
$routes->setDefaultController('Home');
$routes->setDefaultMethod('index');
$routes->setTranslateURIDashes(true);
$routes->set404Override();
$routes->setAutoRoute(true);

/**
 * --------------------------------------------------------------------
 * Route Definitions
 * --------------------------------------------------------------------
 */

// We get a performance increase by specifying the default
// route since we don't have to scan directories.
$routes->get('admin/connexion', 'Auth\LoginController::login');
$routes->get('adminconnexion', 'Auth\LoginController::login');
$routes->get('connexion', 'Auth\CustomerLogin::login');
$routes->get('/', 'Home::index'); // new
$routes->post('/', 'Home::index');

$routes->get('about-us', 'Home::about'); // new
$routes->get('terms-and-conditions', 'Home::terms'); // new
$routes->get('event-detail', 'Home::eventDetail'); // new
$routes->get('events', 'Home::events'); // new
$routes->get('achievers', 'Home::achievers'); // new
$routes->get('contact-us', 'Home::contact'); // new
$routes->post('contact-us', 'Home::contact');

$routes->get('join-us', 'Home::joinus'); // new

$routes->get('login', 'Home::login'); // new
$routes->post('login', 'Home::login');

$routes->get('verify-otp', 'Home::otp'); // new
$routes->post('verify-otp', 'Home::otp');

$routes->get('package', 'Home::package'); // new
$routes->post('package', 'Home::package');
// $routes->post('package/(:num)', 'Home::package/$1'); // new
// $routes->get('package/(:num)', 'Home::package/$1'); // new

$routes->get('checkout', 'Home::checkout'); // new
$routes->post('checkout', 'Home::checkout');
$routes->post('checkout/(:num)', 'Home::checkout/$1'); // new
$routes->get('checkout/(:num)', 'Home::checkout/$1'); // new



/**
 * --------------------------------------------------------------------
 * Custom Routing 
 * --------------------------------------------------------------------
 */
$routes->group('', ['namespace' => 'App\Controllers'], function($routes) {
	// Registration
	$routes->get('register', 'Auth\RegistrationController::register', ['as' => 'register']);
    $routes->post('register', 'Auth\RegistrationController::attemptRegister');

	// Activation
	$routes->get('activate-account', 'Auth\RegistrationController::activateAccount', ['as' => 'activate-account']);
		
	$routes->get('login', 'Auth\CustomerLogin::login', ['as' => 'login']);
	$routes->post('login', 'Auth\CustomerLogin::attemptLogin');
    $routes->get('logout', 'Auth\CustomerLogin::logout');

	// Forgotten password
	$routes->get('forgot-password', 'Home::forgotPassword', ['as' => 'forgot-password']);
    $routes->post('forgot-password', 'Home::attemptForgotPassword');
	
    // Reset password
    $routes->get('reset-password', 'Auth\PasswordController::resetPassword', ['as' => 'reset-password']);
    $routes->post('reset-password', 'Auth\PasswordController::attemptResetPassword');
	
    // Account settings
    $routes->get('account', 'Auth\Customer::account', ['as' => 'account']);
    $routes->get('myaccount', 'Auth\Customer::myaccount', ['as' => 'myaccount']);
    $routes->get('mypayments', 'Auth\Customer::mypayments', ['as' => 'mypayments']);
	
	$routes->get('downloadfile', 'Auth\Customer::downloadfile'); // new
	$routes->post('downloadfile/(:any)/(:num)', 'Auth\Customer::downloadfile/$1/$2'); // new
    $routes->get('downloadfile/(:any)/(:num)', 'Auth\Customer::downloadfile/$1/$2'); // new
	
	
    $routes->get('uploadfile', 'Auth\Customer::uploadfile', ['as' => 'uploadfile']);
    $routes->post('uploadfile', 'Auth\Customer::uploadfile'); // new
    $routes->post('uploadfile/(:any)', 'Auth\Customer::uploadfile/$1'); // new
    $routes->get('uploadfile/(:any)', 'Auth\Customer::uploadfile/$1'); // new
    $routes->post('uploadfile/(:any)/(:num)', 'Auth\Customer::uploadfile/$1/$2'); // new
    $routes->get('uploadfile/(:any)/(:num)', 'Auth\Customer::uploadfile/$1/$2'); // new
    $routes->post('account', 'Auth\Customer::updateAccount');
    $routes->post('change-email', 'Auth\Customer::changeEmail'); // not used
    $routes->get('confirm-email', 'Auth\Customer::confirmNewEmail'); // not used
    $routes->post('delete-account', 'Auth\Customer::deleteAccount'); // new

    // Profile
    $routes->get('profile', 'Auth\Customer::profile', ['as' => 'profile']); // new 
    $routes->post('update-profile', 'Auth\Customer::updateProfile'); // new
	
	// Customer Change Password
    $routes->get('change-password', 'Auth\Customer::changePassword', ['as' => 'change-password']); // new 
    $routes->post('update-password', 'Auth\Customer::updatePassword'); // new
	
	// Admin URLS
	// Login-out
	$routes->get('admin/connexion', 'Auth\LoginController::login', ['as' => 'admin/connexion']);
	$routes->post('admin/connexion', 'Auth\LoginController::attemptLogin');
    $routes->get('admin/logout', 'Auth\LoginController::logout');
	// Account settings
    $routes->get('admin/dashboard', 'Auth\AccountController::account', ['as' => 'dashboard']);
    $routes->get('myaccount', 'Auth\AccountController::myaccount', ['as' => 'myaccount']);
    $routes->post('admin/dashboard', 'Auth\AccountController::updateAccount');	
    $routes->post('admin/change-email', 'Auth\AccountController::changeEmail'); // not used
    $routes->get('admin/confirm-email', 'Auth\AccountController::confirmNewEmail'); // not used
	$routes->post('admin/change-password', 'Auth\AccountController::changePassword'); // new
    $routes->post('admin/delete-account', 'Auth\AccountController::deleteAccount'); // new */
	
	// Profile
    $routes->get('admin/profile', 'Auth\AccountController::profile', ['as' => 'admin/profile']); // new 
    $routes->post('admin/update-profile', 'Auth\AccountController::updateProfile'); // new
	
	// Leads
    $routes->get('admin/leads', 'Leads::index', ['as' => 'admin/leads']); // new
    $routes->post('admin/leads', 'Leads::index'); // new
    $routes->post('admin/leads/(:any)', 'Leads::index/$1'); // new
    $routes->get('admin/leads/(:any)', 'Leads::index/$1'); // new
	$routes->get('admin/leads/(:any)/(:num)', 'Leads::index/$1/$2'); // new
	
	$routes->get('admin/uploadfiles', 'Leads::uploadfiles'); // new
	$routes->post('admin/uploadfiles/(:any)/(:num)', 'Leads::uploadfiles/$1/$2'); // new
    $routes->get('admin/uploadfiles/(:any)/(:num)', 'Leads::uploadfiles/$1/$2'); // new
	$routes->get('admin/downloadfiles', 'Leads::downloadfiles'); // new
	$routes->post('admin/downloadfiles/(:any)/(:num)', 'Leads::downloadfiles/$1/$2'); // new
    $routes->get('admin/downloadfiles/(:any)/(:num)', 'Leads::downloadfiles/$1/$2'); // new
	
	$routes->get('admin/preview', 'Leads::preview'); // new
	$routes->get('admin/preview/(:any)/(:num)', 'Leads::preview/$1/$2'); // new
    /* $routes->get('admin/users/enable/(:num)', 'Auth\UsersController::enable'); // new
    $routes->get('admin/users/edit/(:num)', 'Auth\UsersController::edit'); // new
    $routes->post('admin/users/update-user', 'Auth\UsersController::update'); // new
    $routes->get('admin/users/delete/(:num)', 'Auth\UsersController::delete'); // new
    $routes->post('admin/users/create-user', 'Auth\UsersController::createUser'); */
	
    // Users
    $routes->get('admin/users', 'Auth\UsersController::users', ['as' => 'admin/users']); // new
    $routes->get('admin/users/enable/(:num)', 'Auth\UsersController::enable'); // new
    $routes->get('admin/users/edit/(:num)', 'Auth\UsersController::edit'); // new
    $routes->post('admin/users/update-user', 'Auth\UsersController::update'); // new
    $routes->get('admin/users/delete/(:num)', 'Auth\UsersController::delete'); // new
    $routes->post('admin/users/create-user', 'Auth\UsersController::createUser');
    $routes->get('admin/users/logs', 'Auth\UsersController::userLogs', ['as' => 'admin/userlogs']); // new

    // Settings
    $routes->get('admin/settings', 'Auth\SettingsController::settings', ['as' => 'admin/settings']); // new
    $routes->post('admin/settings-update-system', 'Auth\SettingsController::updateSystem'); // new
    $routes->post('admin/settings-update-email', 'Auth\SettingsController::updateEmail'); // new
});

/**
 * --------------------------------------------------------------------
 * Additional Routing
 * --------------------------------------------------------------------
 *
 * There will often be times that you need additional routing and you
 * need it to be able to override any defaults in this file. Environment
 * based routes is one such time. require() additional route files here
 * to make that happen.
 *
 * You will have access to the $routes object within that file without
 * needing to reload it.
 */
if (file_exists(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php'))
{
	require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';
}
